unit Win32DLLImport;

interface

//Imports declared using historic syntax can declare the calling
//convention using Delphi directives
{$ifdef TRADITIONAL_IMPORT_SYNTAX}
function DoSomething(I: Integer): Boolean; cdecl;
{$else}
function DoSomething(I: Integer): Boolean;
{$endif}
//Routines declared using the DllImport directive must declare the
//calling convention using an atribute parameter
function DoSomethingElse(const Msg: String): Boolean; cdecl;
function DoSomethingElseA(const Msg: String): Boolean;
function DoSomethingElseW(const Msg: String): Boolean;

implementation

uses
  System.Runtime.InteropServices;

const
  Win32DLL = 'Win32DLL.dll';

//Routines that don't have any text parameters can be declared
//using historic syntax, including the calling convention (in the interface section)
{$ifdef TRADITIONAL_IMPORT_SYNTAX}
function DoSomething(I: Integer): Boolean;
external Win32DLL;
{$else}
[DllImport(Win32DLL, CallingConvention = CallingConvention.Cdecl)]
function DoSomething(I: Integer): Boolean;
external;
{$endif}

//Routines that take text parameters typically require a DllImport attribute to specify:
// - the character set (default is Ansi for Win9x and Unicode for NT)
// - the calling convention (default is stdcall on Win32, cdecl on WinCE)
// - the exported name (if different from the method)

function DoSomethingElse(const Msg: String): Boolean;
external Win32DLL;

[DllImport(Win32DLL, CharSet = CharSet.Ansi,
          CallingConvention = CallingConvention.Cdecl)]
function DoSomethingElseA(const Msg: String): Boolean;
external;

[DllImport(Win32DLL, CharSet = CharSet.Unicode,
           CallingConvention = CallingConvention.Cdecl)]
function DoSomethingElseW(const Msg: String): Boolean;
external;

end.
